﻿using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;

namespace AZVIC.Ei8htPOS.Entities
{
    [DataContract]
    [Serializable]
    public class NETSHelper
    {

        #region Enums
        
        public enum MessageType { Incoming, Outgoing, Normal, Warning, Error };
        
        public enum ControlCharacter
        {
            [StringValue("02")]
            StartOfText = 0x02,
            [StringValue("03")]
            EndOfText = 0x03,
            [StringValue("06")]
            Acknowledge = 0x06,
            [StringValue("15")]
            NegativeAcknowledge = 0x15,
        }
        public enum TransactionType
        {
            [StringValue("32 34")]
            ContactLess,
            [StringValue("33 30")]
            SalesPayment,
            Others
        } 
        #endregion
        
        public class FunctionCodes
        {
            public const string RESPONSE_TEXT = "02";
            public const string MERCHANT_NAME = "D0";
            public const string TERMINAL_ID = "16";
            public const string MERCHANT_ID = "D1";
            public const string BATCH_NUMBER = "50";
            public const string STAN = "H6";
            public const string TRANSCATION_AMOUNT = "40";
            public const string TOTAL_FEE = "ZA";
            public const string FEE_DUE_TO_MERCHANT = "ZB";
            public const string FEE_DUE_FROM_MERCHANT = "ZC";
            public const string CARD_NUMBER = "30";
            public const string EXPIRY_DATE = "C2";
            public const string RESPMESSAGE1 = "R0";
            public const string RESPMESSAGE2 = "R1";
            public const string PURCHASE_FEE = "ZP";
            public const string APPROVAL_CODE = "01";
            public const string CARD_ISSUER_NAME = "D2";
            public const string ADDT_TRANS_INFO = "ZT";
            public const string RETR_REF_NO = "D3";
            public const string CEPAS_VERSION = "C1";
            public const string TRANS_DATA = "C0";

            public const string CARD_NAME = "L7";
            public const string SERVICE_FEE = "41";
            public const string POS_MESSAGES = "L5";
            
            public Dictionary<string, int> KeysDict = new Dictionary<string, int>()
            {
                {RESPONSE_TEXT , 40},
                {MERCHANT_NAME , 69},
                {TERMINAL_ID , 8},
                {MERCHANT_ID,15},
                {BATCH_NUMBER,12},
                {STAN,6},//Initially 6
                {TRANSCATION_AMOUNT,12},
                {TOTAL_FEE,6},//Initially 6
                {FEE_DUE_FROM_MERCHANT,6},//Initially 6
                {FEE_DUE_TO_MERCHANT,6},//Initially 6
                {CARD_NUMBER,16},
                {EXPIRY_DATE,8},
                {RESPMESSAGE1,20},
                {RESPMESSAGE2,20},
                {PURCHASE_FEE,6},//Initially 6
                {APPROVAL_CODE,6},//Initially 6
                {CARD_ISSUER_NAME,10},
                {ADDT_TRANS_INFO,0},
                {RETR_REF_NO,12},
                {CEPAS_VERSION,2},
                {TRANS_DATA,64},
                {CARD_NAME,10},
                {SERVICE_FEE,12},
                {POS_MESSAGES,240}
            };

           
            public Dictionary<string, bool> IsSingleLengthBit = new Dictionary<string, bool>() { 
                {STAN,true},
                {TOTAL_FEE,true},
                {FEE_DUE_FROM_MERCHANT,true},
                {FEE_DUE_TO_MERCHANT,true},
                {PURCHASE_FEE,true},
                {APPROVAL_CODE,true}
            };

            public T RemoveFieldCodes<T>(string curVal, out int DataLength, string FunctionCode)
            {
                FunctionCodes obj = new FunctionCodes();
                curVal = curVal.Substring(4, curVal.Length - 4);
                DataLength = (obj.KeysDict.Keys.Contains(FunctionCode) && obj.KeysDict[FunctionCode] != 0) ? KeysDict[FunctionCode] : int.Parse(curVal.Substring(0, 4));
                if (obj.IsSingleLengthBit.Keys != null && obj.IsSingleLengthBit.Keys.Contains(FunctionCode))
                    curVal = curVal.Substring(2, curVal.Length - 2);
                else
                    curVal = curVal.Substring(4, curVal.Length - 4);
                curVal = TwowayConvertionHEX.FromHexString(curVal.Substring(0, DataLength * 2));
                try
                {
                    T vari;
                    if (typeof(T) == typeof(DateTime))
                    {
                        vari = (T)Convert.ChangeType(DateTime.ParseExact(curVal, "ddMMyyyy", null), typeof(T));
                        return vari;
                    }
                    vari = (T)Convert.ChangeType(curVal, typeof(T));
                    return vari;
                }
                catch (Exception ex)
                {
                    return default(T);
                }


            }
        }

        #region Internal Methods
        public static string GetAmount(decimal AmountVal)
        {
            string valueString = ((int)(AmountVal * 100)).ToString();
            if (valueString.Length < 12)
                valueString = valueString.PadLeft(12, '0');
            return TwowayConvertionHEX.ToHexString(valueString);
        }

        public static string PadDataWithZeros(string val, int TotalLength)
        {
            if (val.Length < TotalLength)
                val = val.PadLeft(TotalLength, '0');
            else
                val = val.Substring(0, TotalLength);
            return TwowayConvertionHEX.ToHexString(val);
        }

        public static string ToBCD(int value)
        {
            if (value < 0 || value > 99999999)
                throw new ArgumentOutOfRangeException("value");
            string val = value.ToString();
            string FirstByte = "", SecondByte = "";
            switch (val.Length)
            {
                case 1:
                    FirstByte = "00";
                    SecondByte = "0" + val.ToString();
                    break;
                case 2:
                    FirstByte = "00";
                    SecondByte = val.Substring(0, 1) + val.Substring(1, 1);
                    break;
                case 3:
                    FirstByte = "0" + val.Substring(0, 1);
                    SecondByte = val.Substring(1, 1) + val.Substring(2, 1);
                    break;
                case 4:
                    FirstByte = val.Substring(0, 1) + val.Substring(1, 1);
                    SecondByte = val.Substring(2, 1) + val.Substring(3, 1);
                    break;
            }

            return string.Format("{0} {1} ", FirstByte, SecondByte);
        }

        public static string CalculateLongitudinalRedundancyCheck(string source)
        {
            int checksum = 0;
            foreach (string chData in source.Trim().Split(new char[] { ' ' }))
            {
                checksum ^= int.Parse(chData, System.Globalization.NumberStyles.HexNumber);
            }

            return checksum.ToString("X2");
        }

        public static string GetFieldCode(string FullText)
        {
            return FullText.Trim().Substring(0, 4);
        } 
        #endregion
        [DataContract]
        [Serializable]
        public class TransactionRequest
        {
            [DataMember]
            public string RequestMessage { get; set; }
            [DataMember]
            public MessageType MessageType { get; set; }
            [DataMember]
            public TransactionType TransactionType { get; set; }
            [DataMember]
            public string ReceiptNumber { get; set; }
            [DataMember]
            public decimal Amount { get; set; }
            [DataMember]
            public string Currency { get; set; }


            #region Internal Properties
            public string SEPERATOR { get { return "1C "; } }

            public string CONTACTLESS_TRX { get { return TwowayConvertionHEX.ToHexString("24"); } }

            public string PURCHASE_TRX { get { return TwowayConvertionHEX.ToHexString("30"); } }

            public string HEADER_FILLER { get { return TwowayConvertionHEX.ToHexString("000000000000"); } }

            public string RFU { get { return TwowayConvertionHEX.ToHexString("00"); } }

            public string EOM { get { return TwowayConvertionHEX.ToHexString("0"); } }

            public string FIELDCOUNT { get { return TwowayConvertionHEX.ToHexString("40"); } }

            public string ECRREFNO { get { return TwowayConvertionHEX.ToHexString("H4"); } }

            public string ENHANCEDECR { get { return TwowayConvertionHEX.ToHexString("HD"); } }

            public string TTINDICATOR { get { return TwowayConvertionHEX.ToHexString("T2"); } }

            public string AMOUNT_MESSAGE_LENGTH { get { return ToBCD(12); } }

            public string TOBCDVALUE(int val)
            {
                return ToBCD(val);
            }
            #endregion

            public override string ToString()
            {
                if (this.MessageType.Equals(MessageType.Incoming) && this.TransactionType.Equals(TransactionType.ContactLess))
                {
                    StringBuilder request = new StringBuilder();
                    StringBuilder message = new StringBuilder();
                    request.Append("02 ");

                    message.Append(HEADER_FILLER);
                    message.Append(CONTACTLESS_TRX);
                    message.Append(RFU);
                    message.Append(EOM);
                    message.Append(SEPERATOR);
                    //Add Amount Field
                    message.Append(FIELDCOUNT);
                    message.Append(AMOUNT_MESSAGE_LENGTH);
                    message.Append(GetAmount(Amount));
                    message.Append(SEPERATOR);
                    //Add Reference Number
                    message.Append(ECRREFNO);
                    message.Append(TOBCDVALUE(10));
                    message.Append(PadDataWithZeros(this.ReceiptNumber.Replace("RCT", ""), 10));
                    message.Append(SEPERATOR);

                    string MessageLength = ToBCD(message.ToString().Replace(" ", "").Length / 2);
                    message.Append("03 ");

                    string LRC = CalculateLongitudinalRedundancyCheck(MessageLength + message.ToString()).ToString().PadLeft(2, '0');
                    request.Append(MessageLength);
                    request.Append(message);
                    request.Append(LRC);

                    return request.ToString();
                }
                else
                {
                    StringBuilder request = new StringBuilder();
                    StringBuilder message = new StringBuilder();
                    request.Append("02 ");

                    message.Append(HEADER_FILLER);
                    message.Append(PURCHASE_TRX);
                    message.Append(RFU);
                    message.Append(EOM);
                    message.Append(SEPERATOR);
                    //Transaction Type Indicator
                    message.Append(TTINDICATOR);
                    message.Append(TOBCDVALUE(2));
                    message.Append(TwowayConvertionHEX.ToHexString("01")); //NETS Purchase Code
                    message.Append(SEPERATOR);

                    //Loyalty Redemption
                    message.Append(TwowayConvertionHEX.ToHexString("43")); //Loyalty Redemption COde
                    message.Append(TOBCDVALUE(1));
                    message.Append(TwowayConvertionHEX.ToHexString("0")); //NETS Purchase Code
                    message.Append(SEPERATOR);

                    //Add Amount Field
                    message.Append(FIELDCOUNT);
                    message.Append(AMOUNT_MESSAGE_LENGTH);
                    message.Append(GetAmount(Amount));
                    message.Append(SEPERATOR);

                    //Add Cash back Field
                    message.Append(TwowayConvertionHEX.ToHexString("42"));
                    message.Append(TOBCDVALUE(12));
                    message.Append(GetAmount(0));
                    message.Append(SEPERATOR);

                    //Add Reference Number
                    message.Append(ENHANCEDECR);
                    message.Append(TOBCDVALUE(13));
                    message.Append(PadDataWithZeros(this.ReceiptNumber.Replace("RCT", ""), 13));
                    message.Append(SEPERATOR);

                    string MessageLength = ToBCD(message.ToString().Replace(" ", "").Length / 2);
                    message.Append("03 ");

                    string LRC = CalculateLongitudinalRedundancyCheck(MessageLength + message.ToString()).ToString().PadLeft(2, '0');
                    request.Append(MessageLength);
                    request.Append(message);
                    request.Append(LRC);

                    return request.ToString();
                }
            }

            public byte[] ToByte()
            {
                byte[] req = new byte[48];

                int i = 0;

                req[i++] = 02;

                req[i++] = 00;
                req[i++] = 43;

                req[i++] = byte.Parse(TwowayConvertionHEX.ToHexString("P"));

                req[i++] = 30;

                foreach (char item in ReceiptNumber.PadRight(20, ' ').ToCharArray())
                {
                    req[i++] = byte.Parse(TwowayConvertionHEX.ToHexString(item.ToString()));
                }

                foreach (char item in (Amount * 100).ToString("#").PadLeft(12, '0').ToCharArray())
                {
                    req[i++] = byte.Parse(TwowayConvertionHEX.ToHexString(item.ToString()));
                }

                req[i++] = 03;

                req[i++] = 00;


                return req;
            }
        }
        [DataContract]
        [Serializable]
        public class TransactionResponse : FunctionCodes
        {

            #region Constructors
            public TransactionResponse()
            {

            }

            public TransactionResponse(IDataReader reader)
            {
                DeviceRequest = reader.IsDBNull(reader.GetOrdinal("DeviceRequest")) ? string.Empty : reader.GetString(reader.GetOrdinal("DeviceRequest"));
                DeviceResponse = reader.IsDBNull(reader.GetOrdinal("DeviceResponse")) ? string.Empty : reader.GetString(reader.GetOrdinal("DeviceResponse"));
                ResponseText = reader.IsDBNull(reader.GetOrdinal("ResponseText")) ? string.Empty : reader.GetString(reader.GetOrdinal("ResponseText"));
                MerchantName = reader.IsDBNull(reader.GetOrdinal("MerchantName")) ? string.Empty : reader.GetString(reader.GetOrdinal("MerchantName"));
                TerminalID = reader.IsDBNull(reader.GetOrdinal("TerminalID")) ? string.Empty : reader.GetString(reader.GetOrdinal("TerminalID"));
                MerchantID = reader.IsDBNull(reader.GetOrdinal("MerchantID")) ? string.Empty : reader.GetString(reader.GetOrdinal("MerchantID"));
                BatchNumber = reader.IsDBNull(reader.GetOrdinal("BatchNumber")) ? string.Empty : reader.GetString(reader.GetOrdinal("BatchNumber"));
                STANval = reader.IsDBNull(reader.GetOrdinal("STAN")) ? string.Empty : reader.GetString(reader.GetOrdinal("STAN"));

                CardNumber = reader.IsDBNull(reader.GetOrdinal("CardNumber")) ? string.Empty : reader.GetString(reader.GetOrdinal("CardNumber"));
                RespMessage1 = reader.IsDBNull(reader.GetOrdinal("RespMessage1")) ? string.Empty : reader.GetString(reader.GetOrdinal("RespMessage1"));
                RespMessage2 = reader.IsDBNull(reader.GetOrdinal("RespMessage2")) ? string.Empty : reader.GetString(reader.GetOrdinal("RespMessage2"));
                ApprovalCode = reader.IsDBNull(reader.GetOrdinal("ApprovalCode")) ? string.Empty : reader.GetString(reader.GetOrdinal("ApprovalCode"));
                CardIssuerName = reader.IsDBNull(reader.GetOrdinal("CardIssuerName")) ? string.Empty : reader.GetString(reader.GetOrdinal("CardIssuerName"));
                AdditionalTransactionInfo = reader.IsDBNull(reader.GetOrdinal("AdditionalTransactionInfo")) ? string.Empty : reader.GetString(reader.GetOrdinal("AdditionalTransactionInfo"));
                RetreivalReferenceNo = reader.IsDBNull(reader.GetOrdinal("RetrievalRefNumber")) ? string.Empty : reader.GetString(reader.GetOrdinal("RetrievalRefNumber"));
                CEPASVersion = reader.IsDBNull(reader.GetOrdinal("CEPASVersion")) ? string.Empty : reader.GetString(reader.GetOrdinal("CEPASVersion"));
                TDTransactionType = reader.IsDBNull(reader.GetOrdinal("TDTransactionType")) ? string.Empty : reader.GetString(reader.GetOrdinal("TDTransactionType"));
                TDPostCardStatus = reader.IsDBNull(reader.GetOrdinal("TDPostCardStatus")) ? string.Empty : reader.GetString(reader.GetOrdinal("TDPostCardStatus"));
                CardName = reader.IsDBNull(reader.GetOrdinal("CardName")) ? string.Empty : reader.GetString(reader.GetOrdinal("CardName"));
                POSMessages = reader.IsDBNull(reader.GetOrdinal("POSMessages")) ? string.Empty : reader.GetString(reader.GetOrdinal("POSMessages"));
                CardName = reader.IsDBNull(reader.GetOrdinal("CardName")) ? string.Empty : reader.GetString(reader.GetOrdinal("CardName"));

                ResponseType = reader.IsDBNull(reader.GetOrdinal("TransactionType")) ? TransactionType.Others : (string.IsNullOrEmpty(reader.GetString(reader.GetOrdinal("TransactionType"))) ? TransactionType.Others : (TransactionType)Enum.Parse(typeof(TransactionType), reader.GetString(reader.GetOrdinal("TransactionType"))));
                IsApproved = reader.IsDBNull(reader.GetOrdinal("IsApproved")) ? false : reader.GetBoolean(reader.GetOrdinal("IsApproved"));
                IsActive = reader.IsDBNull(reader.GetOrdinal("IsActive")) ? false : reader.GetBoolean(reader.GetOrdinal("IsActive"));

                TransactionAmount = reader.IsDBNull(reader.GetOrdinal("TransactionAmount")) ? decimal.MinValue : reader.GetDecimal(reader.GetOrdinal("TransactionAmount"));
                TotalFee = reader.IsDBNull(reader.GetOrdinal("TotalFee")) ? decimal.MinValue : reader.GetDecimal(reader.GetOrdinal("TotalFee"));
                FeeDueToMerchant = reader.IsDBNull(reader.GetOrdinal("FeeDueToMerchant")) ? decimal.MinValue : reader.GetDecimal(reader.GetOrdinal("FeeDueToMerchant"));
                FeeDueFromMerchant = reader.IsDBNull(reader.GetOrdinal("FeeDueFromMerchant")) ? decimal.MinValue : reader.GetDecimal(reader.GetOrdinal("FeeDueFromMerchant"));
                PurchaseFee = reader.IsDBNull(reader.GetOrdinal("PurchaseFee")) ? decimal.MinValue : reader.GetDecimal(reader.GetOrdinal("PurchaseFee"));
                TDTransactionAmount = reader.IsDBNull(reader.GetOrdinal("TDTransactionAmount")) ? decimal.MinValue : reader.GetDecimal(reader.GetOrdinal("TDTransactionAmount"));
                TDPriorBalance = reader.IsDBNull(reader.GetOrdinal("TDPriorBalance")) ? decimal.MinValue : reader.GetDecimal(reader.GetOrdinal("TDPriorBalance"));
                TDPostBalance = reader.IsDBNull(reader.GetOrdinal("TDPostBalance")) ? decimal.MinValue : reader.GetDecimal(reader.GetOrdinal("TDPostBalance"));
                TDPostAutoLoad = reader.IsDBNull(reader.GetOrdinal("TDPostAutoLoad")) ? decimal.MinValue : reader.GetDecimal(reader.GetOrdinal("TDPostAutoLoad"));
                ServiceFee = reader.IsDBNull(reader.GetOrdinal("ServiceFee")) ? decimal.MinValue : reader.GetDecimal(reader.GetOrdinal("ServiceFee"));

                ExpiryDate = reader.IsDBNull(reader.GetOrdinal("ExpiryDate")) ? DateTime.MinValue : reader.GetDateTime(reader.GetOrdinal("ExpiryDate"));
                CreatedDate = reader.IsDBNull(reader.GetOrdinal("CreatedDate")) ? DateTime.MinValue : reader.GetDateTime(reader.GetOrdinal("CreatedDate"));
                ModifiedDate = reader.IsDBNull(reader.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : reader.GetDateTime(reader.GetOrdinal("ModifiedDate"));
                TDTransactionDate = reader.IsDBNull(reader.GetOrdinal("TDTransactionDate")) ? DateTime.MinValue : reader.GetDateTime(reader.GetOrdinal("TDTransactionDate"));

                AdminUserAccountID = reader.IsDBNull(reader.GetOrdinal("CreatedBy")) ? Guid.Empty : reader.GetGuid(reader.GetOrdinal("CreatedBy"));
                UniqueID = reader.IsDBNull(reader.GetOrdinal("NetsPaymentID")) ? Guid.Empty : reader.GetGuid(reader.GetOrdinal("NetsPaymentID"));
                OrdersPaymentID = reader.IsDBNull(reader.GetOrdinal("OrdersPaymentID")) ? Guid.Empty : reader.GetGuid(reader.GetOrdinal("OrdersPaymentID"));

            } 
            #endregion

            #region Data Members
            [DataMember]
            public string DeviceRequest { get; set; }
            [DataMember]
            public string DeviceResponse { get; set; }
            [DataMember]
            public TransactionType ResponseType { get; set; }
            [DataMember]
            public int TransactionTypeVal { get; set; }
            [DataMember]
            public bool IsApproved { get; set; }
            [DataMember]
            public string ResponseText { get; set; }
            [DataMember]
            public string MerchantName { get; set; }
            [DataMember]
            public string TerminalID { get; set; }
            [DataMember]
            public string MerchantID { get; set; }
            [DataMember]
            public string BatchNumber { get; set; }
            [DataMember]
            public string STANval { get; set; }
            [DataMember]
            public decimal TransactionAmount { get; set; }
            [DataMember]
            public decimal TotalFee { get; set; }
            [DataMember]
            public decimal FeeDueToMerchant { get; set; }
            [DataMember]
            public decimal FeeDueFromMerchant { get; set; }
            [DataMember]
            public string CardNumber { get; set; }
            [DataMember]
            public DateTime ExpiryDate { get; set; }
            [DataMember]
            public string RespMessage1 { get; set; }
            [DataMember]
            public string RespMessage2 { get; set; }
            [DataMember]
            public decimal PurchaseFee { get; set; }
            [DataMember]
            public string ApprovalCode { get; set; }
            [DataMember]
            public string CardIssuerName { get; set; }
            [DataMember]
            public string AdditionalTransactionInfo { get; set; }
            [DataMember]
            public string RetreivalReferenceNo { get; set; }
            [DataMember]
            public string CEPASVersion { get; set; }
            [DataMember]
            public string TDTransactionType { get; set; }
            [DataMember]
            public decimal TDTransactionAmount { get; set; }
            [DataMember]
            public DateTime TDTransactionDate { get; set; }
            //public string TDTransactionTime { get; set; }
            [DataMember]
            public decimal TDPriorBalance { get; set; }
            [DataMember]
            public decimal TDPostBalance { get; set; }
            [DataMember]
            public decimal TDPostAutoLoad { get; set; }
            [DataMember]
            public string TDPostCardStatus { get; set; }

            [DataMember]
            public string CardName { get; set; }
            [DataMember]
            public decimal ServiceFee { get; set; }
            [DataMember]
            public string POSMessages { get; set; }
            [DataMember]
            public Guid AdminUserAccountID { get; set; }
            [DataMember]
            public DateTime CreatedDate { get; set; }
            [DataMember]
            public DateTime ModifiedDate { get; set; }
            [DataMember]
            public GlobalConfigurations.Mode Mode { get; set; }
            [DataMember]
            public bool IsActive { get; set; }
            [DataMember]
            public Guid UniqueID { get; set; }
            [DataMember]
            public Guid OrdersPaymentID { get; set; } 
            #endregion

            public void ProcessResponseString()
            {
                if (!string.IsNullOrEmpty(DeviceResponse))
                {
                    IsApproved = false;
                    
                    string decryptMessage = DeviceResponse.Trim().Replace(StringValueAttribute.GetStringValue(ControlCharacter.Acknowledge), string.Empty); //Replace ACK,NewLine and Empty string to string.Empty
                    decryptMessage = decryptMessage.Substring(3, decryptMessage.Length - 3);
                    decryptMessage = decryptMessage.Substring(0, decryptMessage.LastIndexOf("03"));

                    string msgLength = decryptMessage.Substring(0, 5);
                    decryptMessage = decryptMessage.Substring(5, decryptMessage.Length - 5);
                    decryptMessage = decryptMessage.Replace("1C", "|");
                    decryptMessage = decryptMessage.Replace(" ", "");


                    string[] MessageData = decryptMessage.Split('|');
                    string HeaderData = MessageData[0];

                    HeaderData = HeaderData.Substring(24, HeaderData.Length - 24);
                    string FunctionCode = HeaderData.Substring(0, 4);

                    HeaderData = HeaderData.Substring(4, HeaderData.Length - 4);
                    string ResponseCode = HeaderData.Substring(0, 4);

                    if (StringValueAttribute.GetStringValue(TransactionType.ContactLess).Replace(" ", "").Equals(FunctionCode))
                    {
                        ResponseType = TransactionType.ContactLess;
                        TransactionTypeVal = 0;
                    }
                    else if (StringValueAttribute.GetStringValue(TransactionType.SalesPayment).Replace(" ", "").Equals(FunctionCode))
                    {
                        ResponseType = TransactionType.SalesPayment;
                        TransactionTypeVal = 1;
                    }
                    else
                    {
                        ResponseType = TransactionType.Others;
                        TransactionTypeVal = 2;
                    }



                    IsApproved = ResponseCode.Trim().Equals("3030");

                    MessageData[0] = string.Empty;

                    foreach (string val in MessageData)
                    {
                        string curVal = val.Replace(" ", "");
                        int DataLength = 0;
                        if (!string.IsNullOrEmpty(curVal))
                        {
                            string CurrentField = TwowayConvertionHEX.FromHexString(GetFieldCode(curVal));
                            switch (CurrentField)
                            {
                                case APPROVAL_CODE:
                                    ApprovalCode = RemoveFieldCodes<string>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal)));
                                    break;
                                case RETR_REF_NO:
                                    RetreivalReferenceNo = RemoveFieldCodes<string>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal)));
                                    break;
                                case CARD_NAME:
                                    CardName = RemoveFieldCodes<string>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal)));
                                    break;
                                case TRANSCATION_AMOUNT:
                                    TransactionAmount = RemoveFieldCodes<decimal>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal)))/100;
                                    break;
                                case SERVICE_FEE:
                                    ServiceFee = RemoveFieldCodes<decimal>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal))) / 100;
                                    break;
                                case TRANS_DATA:
                                    if ((!string.IsNullOrEmpty(curVal)))
                                    {
                                        curVal = curVal.Substring(8, curVal.Length - 8);
                                        if (curVal.Length == 128)
                                        {
                                            TDTransactionType = TwowayConvertionHEX.FromHexString(curVal.Substring(0, 4));

                                            TDTransactionAmount = decimal.Parse(TwowayConvertionHEX.FromHexString(curVal.Substring(4, 24))) / 100;
                                            try
                                            {
                                                TDTransactionDate = DateTime.ParseExact(TwowayConvertionHEX.FromHexString(curVal.Substring(28, 24)), "yyMMddhhmmss", null);
                                            }
                                            catch
                                            {
                                                TDTransactionDate = default(DateTime);
                                            }
                                            //TDTransactionTime = TwowayConvertionHEX.FromHexString(curVal.Substring(40, 12));

                                            TDPriorBalance = decimal.Parse(TwowayConvertionHEX.FromHexString(curVal.Substring(52, 24))) /100;

                                            TDPostBalance = decimal.Parse(TwowayConvertionHEX.FromHexString(curVal.Substring(76, 24))) /100;

                                            TDPostAutoLoad = decimal.Parse(TwowayConvertionHEX.FromHexString(curVal.Substring(100, 24))) /100;

                                            TDPostCardStatus = TwowayConvertionHEX.FromHexString(curVal.Substring(124, 4));
                                        }
                                    }
                                    break;
                                case POS_MESSAGES:
                                    POSMessages = RemoveFieldCodes<string>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal)));
                                    break;
                                case RESPMESSAGE1:
                                    RespMessage1 = RemoveFieldCodes<string>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal)));
                                    break;
                                case RESPMESSAGE2:
                                    RespMessage2 = RemoveFieldCodes<string>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal)));
                                    break;
                                case RESPONSE_TEXT:
                                    ResponseText = RemoveFieldCodes<string>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal)));
                                    break;
                                case MERCHANT_NAME:
                                    MerchantName = RemoveFieldCodes<string>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal)));
                                    break;
                                case TERMINAL_ID:
                                    TerminalID = RemoveFieldCodes<string>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal)));
                                    break;
                                case MERCHANT_ID:
                                    MerchantID = RemoveFieldCodes<string>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal)));
                                    break;
                                case BATCH_NUMBER:
                                    BatchNumber = RemoveFieldCodes<string>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal)));
                                    break;
                                case STAN:
                                    STANval = RemoveFieldCodes<string>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal)));
                                    break;
                                case TOTAL_FEE:
                                    TotalFee = RemoveFieldCodes<decimal>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal))) /100;
                                    break;
                                case FEE_DUE_TO_MERCHANT:
                                    FeeDueToMerchant = RemoveFieldCodes<decimal>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal))) /100;
                                    break;
                                case FEE_DUE_FROM_MERCHANT:
                                    FeeDueFromMerchant = RemoveFieldCodes<decimal>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal))) /100;
                                    break;
                                case CARD_NUMBER:
                                    CardNumber = RemoveFieldCodes<string>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal)));
                                    break;
                                case EXPIRY_DATE:
                                    ExpiryDate = RemoveFieldCodes<DateTime>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal)));
                                    break;
                                case PURCHASE_FEE:
                                    PurchaseFee = RemoveFieldCodes<decimal>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal))) / 100;
                                    break;
                                case CARD_ISSUER_NAME:
                                    CardIssuerName = RemoveFieldCodes<string>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal))); ;
                                    break;
                                case ADDT_TRANS_INFO:
                                    AdditionalTransactionInfo = RemoveFieldCodes<string>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal)));
                                    break;
                                case CEPAS_VERSION:
                                    CEPASVersion = RemoveFieldCodes<string>(curVal, out DataLength, TwowayConvertionHEX.FromHexString(GetFieldCode(curVal)));
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    //if (!string.IsNullOrEmpty(this.TDTransactionTime))
                    //{
                    //    this.TDTransactionDate = new DateTime(TDTransactionDate.Year, TDTransactionDate.Month, TDTransactionDate.Day,
                    //        int.Parse(TDTransactionTime.Substring(0, 2)), int.Parse(TDTransactionTime.Substring(2, 2)), int.Parse(TDTransactionTime.Substring(4, 2)));

                    //}
                }
            }
        }
    }
}
